/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.qsl.tag.impl.client;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3494;
import net.minecraft.class_3503;
import net.minecraft.class_3505;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5458;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.jetbrains.annotations.ApiStatus;
import org.quiltmc.qsl.tag.api.QuiltTagKey;
import org.quiltmc.qsl.tag.api.TagRegistry;
import org.quiltmc.qsl.tag.api.TagType;
import org.quiltmc.qsl.tag.impl.TagRegistryImpl;
import org.quiltmc.qsl.tag.impl.client.QuiltRegistryEntryReferenceHooks;
import org.quiltmc.qsl.tag.mixin.client.TagGroupLoaderAccessor;

@ApiStatus.Internal
public final class ClientTagRegistryManager<T> {
    private static final Map<class_5321<? extends class_2378<?>>, ClientTagRegistryManager<?>> TAG_GROUP_MANAGERS = new WeakHashMap();
    private final class_5321<? extends class_2378<T>> registryKey;
    private final ClientRegistryFetcher registryFetcher;
    private final class_3503<class_6880<T>> loader;
    private class_5455 registryManager = class_5458.field_36476;
    private Map<class_2960, class_3494.class_3495> serializedTags = Map.of();
    private Map<class_6862<T>, class_3494<class_6880<T>>> clientOnlyValues;
    private Map<class_2960, class_3494.class_3495> fallbackSerializedTags = Map.of();
    private Map<class_6862<T>, class_3494<class_6880<T>>> fallbackValues;

    private ClientTagRegistryManager(class_5321<? extends class_2378<T>> registryKey, String dataType) {
        this.registryKey = registryKey;
        this.registryFetcher = new ClientRegistryFetcher();
        this.loader = new class_3503((Function)this.registryFetcher, dataType);
    }

    public class_3494<class_6880<T>> getClientTag(class_6862<T> key) {
        if (this.clientOnlyValues != null) {
            return this.clientOnlyValues.getOrDefault(key, class_3494.method_40088());
        }
        return class_3494.method_40088();
    }

    public Stream<TagRegistry.TagEntry<T>> streamClientTags() {
        return this.clientOnlyValues.entrySet().stream().map(entry -> new TagRegistry.TagEntry((class_6862)entry.getKey(), (class_3494)entry.getValue()));
    }

    @Environment(value=EnvType.CLIENT)
    public void setSerializedTags(Map<class_2960, class_3494.class_3495> serializedTags) {
        this.serializedTags = serializedTags;
        this.clientOnlyValues = this.buildDynamicGroup(this.serializedTags, TagType.CLIENT_ONLY);
        this.bindTags(this.clientOnlyValues, (ref, tags) -> ((QuiltRegistryEntryReferenceHooks)ref).quilt$setClientTags(tags));
    }

    public class_3494<class_6880<T>> getFallbackTag(class_6862<T> key) {
        if (this.fallbackValues != null) {
            return this.fallbackValues.getOrDefault(key, class_3494.method_40088());
        }
        return class_3494.method_40088();
    }

    public Stream<TagRegistry.TagEntry<T>> streamFallbackTags(Predicate<Map.Entry<class_6862<T>, class_3494<class_6880<T>>>> filter) {
        return this.clientOnlyValues.entrySet().stream().filter(filter).map(entry -> new TagRegistry.TagEntry((class_6862)entry.getKey(), (class_3494)entry.getValue()));
    }

    @Environment(value=EnvType.CLIENT)
    public void setFallbackSerializedTags(Map<class_2960, class_3494.class_3495> serializedTags) {
        this.fallbackSerializedTags = serializedTags;
        this.fallbackValues = this.buildDynamicGroup(this.fallbackSerializedTags, TagType.CLIENT_FALLBACK);
        this.bindTags(this.fallbackValues, (ref, tags) -> ((QuiltRegistryEntryReferenceHooks)ref).quilt$setFallbackTags(tags));
    }

    @Environment(value=EnvType.CLIENT)
    public Map<class_2960, class_3494.class_3495> load(class_3300 resourceManager) {
        return this.loader.method_33174(resourceManager);
    }

    @Environment(value=EnvType.CLIENT)
    public void apply(class_5455 registryManager) {
        this.registryManager = registryManager;
        this.setSerializedTags(this.serializedTags);
        this.setFallbackSerializedTags(this.fallbackSerializedTags);
    }

    @Environment(value=EnvType.CLIENT)
    private Map<class_6862<T>, class_3494<class_6880<T>>> buildDynamicGroup(Map<class_2960, class_3494.class_3495> tagBuilders, TagType type) {
        if (!TagRegistryImpl.isRegistryDynamic(this.registryKey)) {
            Object2ObjectOpenHashMap tags = new Object2ObjectOpenHashMap();
            Map built = this.loader.method_18242(tagBuilders);
            built.forEach((id, tag) -> tags.put(QuiltTagKey.of(this.registryKey, id, type), tag));
            return tags;
        }
        Object2ObjectOpenHashMap tags = new Object2ObjectOpenHashMap();
        Function<class_2960, class_3494> tagGetter = id -> (class_3494)tags.get(QuiltTagKey.of(this.registryKey, id, type));
        Function<class_2960, class_6880> registryGetter = identifier -> this.registryFetcher.apply((class_2960)identifier).orElse(null);
        HashMultimap tagEntries = HashMultimap.create();
        tagBuilders.forEach((arg_0, arg_1) -> ClientTagRegistryManager.lambda$buildDynamicGroup$8((Multimap)tagEntries, arg_0, arg_1));
        tagBuilders.forEach((arg_0, arg_1) -> ClientTagRegistryManager.lambda$buildDynamicGroup$10((Multimap)tagEntries, arg_0, arg_1));
        HashSet set = new HashSet();
        tagBuilders.keySet().forEach(arg_0 -> this.lambda$buildDynamicGroup$12(tagBuilders, (Multimap)tagEntries, set, tags, type, tagGetter, registryGetter, arg_0));
        return tags;
    }

    @Environment(value=EnvType.CLIENT)
    private class_3494<class_6880<T>> buildLenientTag(class_3494.class_3495 tagBuilder, Function<class_2960, class_3494<class_6880<T>>> tagGetter, Function<class_2960, class_6880<T>> objectGetter) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        tagBuilder.method_26785().forEach(trackedEntry -> trackedEntry.comp_324().method_26790(tagGetter, objectGetter, arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0)));
        return new class_3494((Collection)builder.build());
    }

    @Environment(value=EnvType.CLIENT)
    public void bindTags(Map<class_6862<T>, class_3494<class_6880<T>>> map, BiConsumer<class_6880.class_6883<T>, List<class_6862<T>>> consumer) {
        Optional registry = this.registryManager.method_33310(this.registryKey);
        if (registry.isEmpty()) {
            return;
        }
        IdentityHashMap boundTags = new IdentityHashMap();
        ((class_2378)registry.get()).method_40270().forEach(reference -> boundTags.put((class_6880.class_6883)reference, new ArrayList()));
        map.forEach((tagKey, tag) -> {
            for (class_6880 holder : tag.method_15138()) {
                if (!holder.method_40222((class_2378)registry.get())) {
                    throw new IllegalStateException("Can't create named set " + tagKey + " containing value " + holder + " from outside registry " + registry.get());
                }
                if (!(holder instanceof class_6880.class_6883)) {
                    throw new IllegalStateException("Found direct holder " + holder + " value in tag " + tagKey);
                }
                ((List)boundTags.get(holder)).add(tagKey);
            }
        });
        boundTags.forEach(consumer);
    }

    public static <T> ClientTagRegistryManager<T> get(class_5321<? extends class_2378<T>> registryKey) {
        return TAG_GROUP_MANAGERS.computeIfAbsent(registryKey, key -> new ClientTagRegistryManager(registryKey, class_3505.method_40099((class_5321)key)));
    }

    @Environment(value=EnvType.CLIENT)
    static void init() {
        class_2378.field_11144.forEach((T registry) -> ClientTagRegistryManager.get(registry.method_30517()));
        class_5458.field_25926.forEach((T registry) -> ClientTagRegistryManager.get(registry.method_30517()));
    }

    static void forEach(Consumer<ClientTagRegistryManager<?>> consumer) {
        TAG_GROUP_MANAGERS.values().forEach(consumer);
    }

    @Environment(value=EnvType.CLIENT)
    public static void applyAll(class_5455 registryManager) {
        TAG_GROUP_MANAGERS.forEach((registryKey, manager) -> manager.apply(registryManager));
    }

    private /* synthetic */ void lambda$buildDynamicGroup$12(Map tagBuilders, Multimap tagEntries, HashSet set, Object2ObjectOpenHashMap tags, TagType type, Function tagGetter, Function registryGetter, class_2960 tagId) {
        TagGroupLoaderAccessor.invokeVisitDependenciesAndEntry(tagBuilders, (Multimap<class_2960, class_2960>)tagEntries, set, tagId, (currentTagId, builder) -> tags.put(QuiltTagKey.of(this.registryKey, tagId, type), this.buildLenientTag((class_3494.class_3495)builder, tagGetter, registryGetter)));
    }

    private static /* synthetic */ void lambda$buildDynamicGroup$10(Multimap tagEntries, class_2960 tagId, class_3494.class_3495 builder) {
        builder.method_32828(entryId -> TagGroupLoaderAccessor.invokeAddDependencyIfNotCyclic((Multimap<class_2960, class_2960>)tagEntries, tagId, entryId));
    }

    private static /* synthetic */ void lambda$buildDynamicGroup$8(Multimap tagEntries, class_2960 tagId, class_3494.class_3495 builder) {
        builder.method_32826(tagEntryId -> TagGroupLoaderAccessor.invokeAddDependencyIfNotCyclic((Multimap<class_2960, class_2960>)tagEntries, tagId, tagEntryId));
    }

    private class ClientRegistryFetcher
    implements Function<class_2960, Optional<class_6880<T>>> {
        private boolean firstCall = true;
        private class_5455 lastRegistryManager;
        private class_2378<T> cached;

        private ClientRegistryFetcher() {
        }

        @Override
        public Optional<class_6880<T>> apply(class_2960 id) {
            if (this.firstCall || ClientTagRegistryManager.this.registryManager != this.lastRegistryManager) {
                this.lastRegistryManager = ClientTagRegistryManager.this.registryManager;
                this.cached = this.lastRegistryManager.method_33310(ClientTagRegistryManager.this.registryKey).orElse(null);
                this.firstCall = false;
            }
            if (this.cached == null) {
                return Optional.empty();
            }
            return this.cached.method_40264(class_5321.method_29179((class_5321)this.cached.method_30517(), (class_2960)id));
        }
    }
}

